window.addEventListener("load", function() {
    postMessageToLauncher({
        type: "launcher-request",
        request: "get-status"
    });
});

window.addEventListener("message", function(event) {
    if(event.origin == "https://launcher.ape-apps.com") {
        const message = event.data;

        if(message.type && message.type == "launcher-status") {
            const status = message.result;

            const username = status.username || "Guest";
            const mode = status.mode || "Unknown";

            document.getElementById("status-launcher").innerHTML = "Yes";
            document.getElementById("status-username").innerHTML = username;
            document.getElementById("status-mode").innerHTML = mode;

            /*
                If a username is returned, the user is logged in and authenticated.
                You may customize their experience and attribute data to this user.

                App mode will return either "desktop" or "gamepad" depending on which
                mode the launcher is in.  If the launcher is in gamepad mode, it is
                expected that your app or game supports gamepad input.  If your app
                does not support gamepad mode, you should specify that in the manifest
                file.  Refer to manifest.json for an example.
            */

            /*
                If we are in a Launcher session, we should show a quit option, especially
                for users in Gamepad mode.
            */
            document.getElementById("quitSection").style.display = "block";
            document.getElementById("btnQuit").onclick = function() {
                postMessageToLauncher({
                    type: "launcher-request",
                    request: "quit-application"
                });
            };
        }
    }
});

/*
    Helper to get the window that opened this one (if any)
    Could be window.opener or window.parent depending on mode 
    that the Launcher is in
*/
function postMessageToLauncher(message) {
    let target = null;

    if(window.parent && window.parent.postMessage) {
        target = window.parent;
    }

    if(window.opener && window.opener.postMessage) {
        target = window.opener;
    }

    if(!target) {
        // Probably not running in the Launcher
        return;
    }

    target.postMessage(message, "https://launcher.ape-apps.com");
}